﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="site-path" select="site-path" />
<xsl:variable name="portlet-id" select="portlet/portlet-id" />

<xsl:template match="portlet">
    <div class="portlet-background-colored" >
	
        <xsl:if test="not(string(display-portlet-title)='1')">
            <h3 class="portlet-background-colored-header">
                <xsl:value-of disable-output-escaping="yes" select="portlet-name" />
            </h3>
        </xsl:if>
	<div class="portlet-background-colored-content" >
            <ul>  
                <xsl:apply-templates select="document-list-portlet/document" />
            </ul>  
	</div>
    </div>
</xsl:template>


<xsl:template match="document">      


<xsl:if test="not(string(document-xml-content)='null')">
    <table width="100%"><tr><td width="100%">
    		<li>
        		<a href="{$site-path}?document_id={document-id}&#38;portlet_id={$portlet-id}" target="_top"> 
            		    <xsl:for-each select="descendant::*">   
                		<xsl:value-of select="document-title" />
           		    </xsl:for-each>    
        		</a>
        		<br />
        		<xsl:for-each select="descendant::*">           
            		    <xsl:value-of select="document-summary" />                 
        		</xsl:for-each>  
    		</li></td>

		<td><xsl:for-each select="descendant::*"> 
	        <xsl:choose>
		    <xsl:when test="article-image/file-resource!=''">	
		        <xsl:apply-templates select="article-image/file-resource" />
		    </xsl:when>
		    <xsl:otherwise>               
		    </xsl:otherwise>        
	        </xsl:choose> 
            </xsl:for-each> </td></tr></table>
</xsl:if>
</xsl:template>              

<xsl:template match="file-resource">
        <xsl:choose>
            <xsl:when test="(resource-content-type='image/jpeg' or resource-content-type='image/jpg' or  resource-content-type='image/pjpeg' or resource-content-type='image/gif' or resource-content-type='image/png')" >
               <div class="vignette"><img src="document?id={resource-document-id}&amp;id_attribute={resource-attribute-id}" height="65"/></div>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>        
        </xsl:choose>
</xsl:template>


</xsl:stylesheet>
